VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DLXOCX32.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form AIBufferForm 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Single-Channel, Buffered, Analog Input"
   ClientHeight    =   7500
   ClientLeft      =   2436
   ClientTop       =   3432
   ClientWidth     =   9480
   ControlBox      =   0   'False
   ForeColor       =   &H00000000&
   LinkTopic       =   "Form1"
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   7500
   ScaleWidth      =   9480
   Begin VB.OptionButton Option4 
      Caption         =   "Counts"
      Height          =   492
      Left            =   5280
      TabIndex        =   43
      Top             =   6120
      Width           =   852
   End
   Begin VB.OptionButton Option3 
      Caption         =   "Volts"
      Height          =   372
      Left            =   5280
      TabIndex        =   42
      Top             =   5760
      Value           =   -1  'True
      Width           =   852
   End
   Begin VB.CheckBox Autozero 
      Caption         =   "AutoZero"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.8
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   516
      Left            =   3000
      TabIndex        =   41
      Top             =   6216
      Width           =   1932
   End
   Begin VB.Frame Frame2 
      Caption         =   "Triggering"
      Height          =   1932
      Left            =   6360
      TabIndex        =   37
      Top             =   3360
      Width           =   2652
      Begin VB.CheckBox Check6 
         Caption         =   "Negative"
         Height          =   252
         Left            =   720
         TabIndex        =   45
         Top             =   1560
         Width           =   972
      End
      Begin VB.CheckBox Check5 
         Caption         =   "Analog Trigger"
         Height          =   372
         Left            =   240
         TabIndex        =   44
         Top             =   1200
         Width           =   2052
      End
      Begin VB.CheckBox Check4 
         Caption         =   "External Pacer Clock"
         Height          =   372
         Left            =   240
         TabIndex        =   40
         Top             =   840
         Width           =   2172
      End
      Begin VB.CheckBox Check3 
         Caption         =   "Negative Polarity"
         Height          =   252
         Left            =   720
         TabIndex        =   39
         Top             =   540
         Width           =   1692
      End
      Begin VB.CheckBox Check2 
         Caption         =   "External Digital Trigger"
         Height          =   372
         Left            =   240
         TabIndex        =   38
         Top             =   240
         Width           =   2052
      End
   End
   Begin VB.ListBox List2 
      Height          =   1200
      Left            =   6120
      TabIndex        =   35
      Top             =   5640
      Width           =   3252
   End
   Begin VB.TextBox Text3 
      BackColor       =   &H80000004&
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.6
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   360
      Left            =   0
      TabIndex        =   34
      Text            =   "10"
      Top             =   600
      Width           =   492
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   8880
      Top             =   6960
      _ExtentX        =   677
      _ExtentY        =   677
      _Version        =   393216
   End
   Begin VB.CommandButton Command6 
      Caption         =   "Save Data"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.6
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   492
      Left            =   7080
      TabIndex        =   33
      Top             =   6960
      Width           =   1452
   End
   Begin VB.Frame Frame3 
      Caption         =   "Channel / Gain List"
      Height          =   2652
      Left            =   4800
      TabIndex        =   21
      Top             =   600
      Width           =   3492
      Begin VB.ListBox List1 
         Height          =   1392
         Left            =   2160
         TabIndex        =   31
         Top             =   600
         Width           =   1092
      End
      Begin VB.CommandButton Command5 
         Caption         =   "Clear"
         Height          =   372
         Left            =   2400
         TabIndex        =   30
         Top             =   2160
         Width           =   732
      End
      Begin VB.CommandButton Command4 
         Caption         =   "Delete"
         Height          =   372
         Left            =   1320
         TabIndex        =   29
         Top             =   2160
         Width           =   732
      End
      Begin VB.CommandButton Command3 
         Caption         =   "Add"
         Height          =   372
         Left            =   240
         TabIndex        =   28
         Top             =   2160
         Width           =   732
      End
      Begin VB.TextBox Text14 
         Height          =   372
         Left            =   960
         TabIndex        =   24
         Text            =   "0"
         Top             =   960
         Width           =   852
      End
      Begin VB.TextBox Text13 
         Height          =   372
         Left            =   960
         TabIndex        =   23
         Text            =   "-1"
         Top             =   1560
         Width           =   852
      End
      Begin VB.TextBox Text12 
         Height          =   372
         Left            =   960
         TabIndex        =   22
         Text            =   "0"
         Top             =   360
         Width           =   852
      End
      Begin VB.Label Label17 
         Caption         =   "Channel List"
         Height          =   252
         Left            =   2160
         TabIndex        =   32
         Top             =   360
         Width           =   1092
      End
      Begin VB.Label Label20 
         Caption         =   "SE / DE 0, 2, 3"
         Height          =   492
         Left            =   120
         TabIndex        =   27
         Top             =   960
         Width           =   732
      End
      Begin VB.Label Label19 
         Caption         =   "Gain (- for bipolar)"
         Height          =   372
         Left            =   120
         TabIndex        =   26
         Top             =   1560
         Width           =   732
      End
      Begin VB.Label Label18 
         Caption         =   "Channel"
         Height          =   252
         Left            =   120
         TabIndex        =   25
         Top             =   480
         Width           =   732
      End
   End
   Begin VB.CommandButton Command2 
      Caption         =   "DIO"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.6
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   492
      Left            =   8520
      TabIndex        =   20
      Top             =   2160
      Width           =   852
   End
   Begin VB.CommandButton Command1 
      Caption         =   "D/A"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.6
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   492
      Left            =   8520
      TabIndex        =   19
      Top             =   1440
      Width           =   852
   End
   Begin VB.CheckBox Check1 
      Caption         =   "Continuous"
      Height          =   372
      Left            =   4800
      TabIndex        =   18
      Top             =   3960
      Width           =   1332
   End
   Begin VB.TextBox Text6 
      Height          =   372
      Left            =   8520
      TabIndex        =   14
      Text            =   "0"
      Top             =   840
      Width           =   852
   End
   Begin VB.Frame Frame1 
      Caption         =   "Transfer"
      Height          =   852
      Left            =   2880
      TabIndex        =   7
      Top             =   5160
      Width           =   2172
      Begin VB.OptionButton Option2 
         Caption         =   "INT"
         Height          =   492
         Left            =   1080
         TabIndex        =   9
         Top             =   240
         Width           =   852
      End
      Begin VB.OptionButton Option1 
         Caption         =   "DMA"
         Height          =   492
         Left            =   120
         TabIndex        =   8
         Top             =   240
         Value           =   -1  'True
         Width           =   972
      End
   End
   Begin VB.TextBox Text2 
      Height          =   372
      Left            =   1440
      TabIndex        =   6
      Text            =   "5000"
      Top             =   5400
      Width           =   852
   End
   Begin VB.TextBox Text1 
      Height          =   372
      Left            =   240
      TabIndex        =   5
      Text            =   "100000"
      Top             =   5400
      Width           =   852
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "E&xit"
      Height          =   372
      Left            =   4800
      TabIndex        =   1
      Top             =   4440
      Width           =   1212
   End
   Begin VB.PictureBox pictureCRT 
      BackColor       =   &H00FFFFC0&
      ForeColor       =   &H000000FF&
      Height          =   4000
      Left            =   480
      ScaleHeight     =   3948
      ScaleWidth      =   3948
      TabIndex        =   4
      Top             =   672
      Width           =   4000
   End
   Begin VB.CommandButton cmdAcquire 
      Caption         =   "&Acquire"
      Default         =   -1  'True
      Height          =   372
      Left            =   4800
      TabIndex        =   0
      Top             =   3480
      Width           =   1212
   End
   Begin DlsrLib.DriverLINXLDD DriverLINXLDD1 
      Left            =   1440
      Top             =   6096
      _Version        =   262144
      _ExtentX        =   593
      _ExtentY        =   593
      _StockProps     =   64
      _Version        =   262144
      _ExtentX        =   593
      _ExtentY        =   593
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR DriverLINXSR1 
      Left            =   1920
      Top             =   6096
      _Version        =   262144
      _ExtentX        =   593
      _ExtentY        =   593
      _StockProps     =   64
   End
   Begin VB.Label Label7 
      Caption         =   "KPCI-3108 Series test example"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.8
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   372
      Left            =   2520
      TabIndex        =   46
      Top             =   120
      Width           =   4812
   End
   Begin VB.Label Label4 
      Caption         =   "Data (Average, RMS, Peak-to-Peak)"
      Height          =   252
      Left            =   6120
      TabIndex        =   36
      Top             =   5400
      Width           =   3012
   End
   Begin VB.Label Label14 
      Caption         =   "0"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.6
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   252
      Left            =   360
      TabIndex        =   17
      Top             =   4680
      Width           =   252
   End
   Begin VB.Label Label13 
      Caption         =   "5000"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.6
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   252
      Left            =   4080
      TabIndex        =   16
      Top             =   4680
      Width           =   612
   End
   Begin VB.Label Label10 
      Caption         =   "Device"
      Height          =   312
      Left            =   8520
      TabIndex        =   15
      Top             =   600
      Width           =   720
   End
   Begin VB.Label Label6 
      Caption         =   "0"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.6
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   252
      Left            =   240
      TabIndex        =   13
      Top             =   2520
      Width           =   372
   End
   Begin VB.Label Label5 
      Caption         =   "-10"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.6
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   252
      Left            =   0
      TabIndex        =   12
      Top             =   4440
      Width           =   492
   End
   Begin VB.Label Label3 
      Caption         =   "Samples"
      Height          =   372
      Left            =   1440
      TabIndex        =   11
      Top             =   5160
      Width           =   852
   End
   Begin VB.Label Label2 
      Caption         =   "Frequency"
      Height          =   372
      Left            =   240
      TabIndex        =   10
      Top             =   5160
      Width           =   852
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Status "
      Height          =   192
      Left            =   216
      TabIndex        =   3
      Top             =   6768
      Width           =   600
   End
   Begin VB.Label lblStatus 
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      Height          =   312
      Left            =   180
      TabIndex        =   2
      Top             =   7032
      Width           =   5868
   End
End
Attribute VB_Name = "AIBufferForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' This example demonstrates how to acquire a single buffer of data
' from your board's analog input subsystem.
' It performs seven DriverLINX operations:
'   1. Open a DriverLINX driver
'   2. Initialize a Logical Device
'   3. See if the Logical Device supports analog input
'   4. Setup the Service Request
'   5. Execute the Service Request
'   6. Process the results
'   7. Close the DriverLINX driver
'
' This application performs steps 1, 2, 3, 4, and 7 once. Every time
'   that you click the form's "Acquire" button, it performs steps 5.
'   It uses the DriverLINXSR bufferFilled event to know when to perform
'   step 6.
'
' Code for this example is divided between three modules:
'   AIBufferForm, which you will find in the file, AIBuffer.frm,
'   DriverLINXGUIInterface, which you will find in DLVBGui.bas, and
'   DriverLINXLibrary, which you will find in the file DLVBLib.bas.
'
' To the extent possible, DriverLINXLibrary contains all
'   DriverLINX/VB-specific code.
'
' AIBufferForm is organized as follows:
'
'   Form_Load() opens a DriverLINX driver, initializes a Logical Device,
'       and checks whether the Logical Device supports analog input.
'
'   Form_Load() then sets up a Service Request that, when executed, will
'       acquire a single, buffer of data from the Logical Device's
'       analog-input susbsystem.
'
'   cmdAcquire_Click() executes the Service Request setup by
'       Form_Load(), and displays the acquired value, along
'       with any error messages from DriverLINX.
'
'   DriverLINXSR1_ServiceStart() updates the form to indicate that a task
'       is currently running.
'
'   DriverLINXSR1_BufferFilled() retrieves data from the DriverLINXSR
'       control, and plots it on the form's CRT panel.
'
'   DriverLINXSR1_ServiceDone() updates the form to indicate that a task
'       has ended.
'
'   vscrollChannelSelector_Change() changes the Logical Channel by updating
'       the value of the Service Request's .Sel_chan_start property.

'   cmdExit_Click() stops any active DriverLINX task, and then closes the
'       DriverLINX driver opened in Form_Load().
'

' With the Option Explicit statement, VB will help catch typing errors
Option Explicit

Dim results As myanswer


Const LogicalDevice As Integer = 0  'DriverLINX Logical Device
Private LogicalChannel As Integer   'DriverLINX Logical Channel
Const ChannelGain As Single = -1#   'Gain setting for Logical Channel
Dim LogicalChannels() As Integer  ' DriverLINX Logical Channel
Dim channelSEDE() As Integer
Dim ChannelGains() As Single      ' Gain setting for Logical Channel

' Sampling frequency = 10 kHz
Dim SamplingFrequency As Single
Dim SamplingPeriod As Single

' Number of buffers
Const NumberOfBuffers As Integer = 1

' Number of samples in a buffer
Dim NumberOfSamples As Long
    
'Number of Channels
Dim NumberOfChannels As Integer

' Duration of data acquisition
Dim FullSweep As Single

' A data storage array
Dim DataArray() As Double
Dim countsarray() As Long

Dim DLMessage As String
Dim DLResultCode As Integer
Dim firstoccur As Integer
Dim secondoccur As Integer
Dim i As Integer
Dim j As Integer
Dim mystring As String

' Status string
Private strStatus As String
' Status strings that indicate normal operation
Const msgRunning As String = "Running"
Const msgStopped As String = "Stopped"

Dim BackGroundForeGround As Integer             'IRQ =1 DMA = 2, Polled = 0

'Graphing Constants
Const Digital As Boolean = False                 'This is a analog I/O example
Const YAxisOffset = 0



Private Sub Command1_Click()

dacform.Show

End Sub

Private Sub Command2_Click()
dioform.Show
End Sub

Private Sub Command3_Click()

'Add Combo box entry to List box
List1.AddItem (Text12.Text + ", " + Text14.Text + ", " + Text13.Text)
Command4.Enabled = True

' Update the number of channels sampled assume 1 as default
    NumberOfChannels = List1.ListCount
    
    'Redim arrays
    ReDim DataArray(0 To NumberOfChannels - 1, 0 To NumberOfSamples - 1) As Double
    ReDim countsarray(0 To NumberOfChannels - 1, 0 To NumberOfSamples - 1) As Long
    ReDim ChannelGains(0 To NumberOfChannels - 1) As Single
    ReDim LogicalChannels(0 To NumberOfChannels - 1) As Integer
    ReDim channelSEDE(0 To NumberOfChannels - 1) As Integer
    
    For i = 0 To NumberOfChannels - 1           'Update Array Information
        firstoccur = InStr(1, List1.List(i), ",", 1)
        LogicalChannels(i) = Mid(List1.List(i), 1, firstoccur - 1)
        secondoccur = InStr(firstoccur + 1, List1.List(i), ",", 1)
        channelSEDE(i) = Mid(List1.List(i), firstoccur + 1, 2)        'Gain is held constant for example
        ChannelGains(i) = Mid(List1.List(i), secondoccur + 1, 5)
        
    Next i
    
    'Update Channel Gain List and Buffers
    AddChannelGainList DriverLINXSR1, DL_AI, NumberOfChannels, LogicalChannels(), ChannelGains(), channelSEDE()
    AddSelectBuffers DriverLINXSR1, NumberOfBuffers, NumberOfSamples, NumberOfChannels

End Sub

Private Sub Command4_Click()
'Remove Selected Channel(s) from listbox
Dim Entries As Integer

'Warn user to select something first
    If List1.SelCount = 0 Then
     MsgBox "There are no selected Channels to Delete!", vbOKOnly, "OOPS!"
        Exit Sub
    End If

'Check which channels were selected and delete channel if selected by user
    Entries = List1.ListCount - 1
    For i = Entries To 0 Step -1
        If List1.Selected(i) = True Then
          List1.RemoveItem i
        End If
    Next i

' Update the number of channels sampled assume 1 as default
    NumberOfChannels = List1.ListCount
    
'Redim arrays
    If (NumberOfChannels > 0) Then
        ReDim ChannelGains(0 To NumberOfChannels - 1) As Single
        ReDim LogicalChannels(0 To NumberOfChannels - 1) As Integer
        ReDim channelSEDE(0 To NumberOfChannels - 1) As Integer
        ReDim DataArray(0 To NumberOfChannels - 1, 0 To NumberOfSamples - 1) As Double
        ReDim countsarray(0 To NumberOfChannels - 1, 0 To NumberOfSamples - 1) As Long
    Else
        ReDim ChannelGains(0) As Single
        ReDim LogicalChannels(0) As Integer
        ReDim channelSEDE(0) As Integer
        ReDim DataArray(0, 0 To NumberOfSamples - 1) As Double
        ReDim countsarray(0, 0 To NumberOfSamples - 1) As Long
    End If
    
    For i = 0 To NumberOfChannels - 1           'Update Array Information
        firstoccur = InStr(1, List1.List(i), ",", 1)
        LogicalChannels(i) = Mid(List1.List(i), 1, firstoccur - 1)
        secondoccur = InStr(firstoccur + 1, List1.List(i), ",", 1)
        channelSEDE(i) = Mid(List1.List(i), firstoccur + 1, 2)        'Gain is held constant for example
        ChannelGains(i) = Mid(List1.List(i), secondoccur + 1, 5)
    Next i
    
'Update Channel Gain List and Buffers
    AddChannelGainList DriverLINXSR1, DL_AI, NumberOfChannels, LogicalChannels(), ChannelGains(), channelSEDE()
    AddSelectBuffers DriverLINXSR1, NumberOfBuffers, NumberOfSamples, NumberOfChannels

'If no channels left disable the delete button
    If NumberOfChannels = 0 Then Command4.Enabled = False

End Sub

Private Sub Command5_Click()

'Clear List box
    List1.Clear

' Update the number of channels sampled assume 1 as default
    NumberOfChannels = List1.ListCount
        
 'Redim arrays
    If (NumberOfChannels > 0) Then
        ReDim ChannelGains(0 To NumberOfChannels - 1) As Single
        ReDim LogicalChannels(0 To NumberOfChannels - 1) As Integer
        ReDim channelSEDE(0 To NumberOfChannels - 1) As Integer
        ReDim DataArray(0 To NumberOfChannels - 1, 0 To NumberOfSamples - 1) As Double
        ReDim countsarray(0 To NumberOfChannels - 1, 0 To NumberOfSamples - 1) As Long
    Else
        ReDim ChannelGains(0) As Single
        ReDim LogicalChannels(0) As Integer
        ReDim channelSEDE(0) As Integer
        ReDim DataArray(0, 0 To NumberOfSamples - 1) As Double
        ReDim countsarray(0, 0 To NumberOfSamples - 1) As Long
    End If
    
    For i = 0 To NumberOfChannels - 1           'Update Array Information
        firstoccur = InStr(1, List1.List(i), ",", 1)
        LogicalChannels(i) = Mid(List1.List(i), 1, firstoccur - 1)
        secondoccur = InStr(firstoccur + 1, List1.List(i), ",", 1)
        channelSEDE(i) = Mid(List1.List(i), firstoccur + 1, 2)        'Gain is held constant for example
        ChannelGains(i) = Mid(List1.List(i), secondoccur + 1, 5)
    Next i
    
'Update Channel Gain List and Buffers
    AddChannelGainList DriverLINXSR1, DL_AI, NumberOfChannels, LogicalChannels(), ChannelGains(), channelSEDE()
    AddSelectBuffers DriverLINXSR1, NumberOfBuffers, NumberOfSamples, NumberOfChannels

'disable the Delete button until atleast one channel has been added
    Command4.Enabled = False

End Sub

Private Sub Command6_Click()

        CommonDialog1.FileName = "*.log"
        CommonDialog1.Filter = "*.log"
        CommonDialog1.ShowSave   'show the save as dialog box for naming the file
    If CommonDialog1.FileName <> "*.log" Then
        'Set fso = CreateObject("Scripting.FileSystemObject")
        'Set txtfile = fso.CreateTextFile(CommonDialog1.FileName, True)
        
        Open CommonDialog1.FileName For Output As #1

        Print #1, "Channel Gain List:"
        
        For i = 0 To NumberOfChannels - 1           'Gain is held constant for example
            Print #1, List1.List(i)
        Next i
        
        Print #1, "Frequency: " + Str(mydevice.freq) + " Samples: " + Str(mydevice.samples)
                
        Print #1, "Sample#, Counts, DriverLinxVolts"
        For j = 0 To NumberOfSamples - 1
            mystring = Str(j)
            For i = 0 To NumberOfChannels - 1
                mystring = mystring + "," + Str(countsarray(i, j)) + ", " + Str(DataArray(i, j))
            Next i
            Print #1, mystring
        Next j
        
        'close file
        'txtfile.Close
        Close #1
        lblStatus.Caption = CommonDialog1.FileName + " is saved."
        
    End If

End Sub

Private Sub DriverLINXSR1_DataLost(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Long, bufElement As Long)
    ' Stop Tasks
    StopDriverLINXIO DriverLINXSR1
    
    'Display Message
    lblStatus.Caption = "Data Lost"
    MsgBox "Data Lost!", vbOKOnly, Me.Name
    
    'Exit Program
    cmdExit_Click
    
End Sub

Private Sub Form_Load()

    Dim channelNumber As Integer
    Dim Model As String
    Dim Msg As String
    
    ' Update the number of channels sampled assume 1 as default
    NumberOfChannels = 1
    
    Set mydevice.SR = DriverLINXSR1
    Set mydevice.LDD = DriverLINXLDD1
    mydevice.DriverName = "KPCI3108"
    mydevice.device = Text6.Text
    mydevice.Buffers = 1
    
    Call Initialize_Device(mydevice)
    
    BackGroundForeGround = 2
    SamplingFrequency = Text1.Text
    SamplingPeriod = 1 / SamplingFrequency
    NumberOfSamples = Text2.Text
    
    mydevice.freq = Text1.Text
    mydevice.samples = Text2.Text
    mydevice.Channel = 0
    mydevice.DMAorINT = 2
    mydevice.gain = -1
    mydevice.samples = Text2.Text
    mydevice.se_de = 0
    
    FullSweep = NumberOfSamples * SamplingPeriod
    
    ' Make sure that this form is centered on the screen
    CenterForm Me
    
   ' Scale form's CRT panel
    InitCRT pictureCRT, FullSweep, 20, Digital, YAxisOffset
                                 'scale graph for 20 volts
                    
                    
    'Redim arrays
    ReDim DataArray(0 To NumberOfChannels - 1, 0 To NumberOfSamples - 1) As Double
    ReDim countsarray(0 To NumberOfChannels - 1, 0 To (NumberOfSamples - 1)) As Long
    ReDim ChannelGains(0 To NumberOfChannels - 1) As Single
    ReDim channelSEDE(0 To NumberOfChannels - 1) As Integer
    ReDim LogicalChannels(0 To NumberOfChannels - 1) As Integer
    
    For i = 0 To NumberOfChannels - 1           'Gain is held constant for example
        ChannelGains(i) = ChannelGain           'First Channel gain
        LogicalChannels(i) = i                  'First Channel in List
        channelSEDE(i) = 0
        
    Next i                                      'Will loop only once
                                                                                                                           

    List1.AddItem (Text12.Text + ", " + Text14.Text + ", " + Text13.Text)
    Command4.Enabled = True
                                                                                                                                               
End Sub

Public Sub Setup_Device()

    InitCRT pictureCRT, FullSweep, Val(Text3.Text) * 2, Digital, YAxisOffset
    
   ' Scale form's CRT panel
    'InitCRT pictureCRT, FullSweep, 20, Digital, YAxisOffset
                                 'scale graph for 20 volts

    ' 4. Setup the Service Request control for single-buffer, analog input LogicalChannel
    'SetupDriverLINXBufferedIO DriverLINXSR1, DriverLINXLDD1, LogicalDevice, DL_AI, LogicalChannel, ChannelGain, SamplingFrequency, NumberOfSamples, NumberOfBuffers, BackGroundForeGround
    ' See CmdAcquire_Click( ) for how to start this task and process data

End Sub

Private Sub cmdAcquire_Click()
    
    ' 4. Setup the Service Request control for single-buffer, analog input LogicalChannel
    'SetupDriverLINXBufferedIO DriverLINXSR1, DriverLINXLDD1, LogicalDevice, DL_AI, LogicalChannel, ChannelGain, SamplingFrequency, NumberOfSamples, NumberOfBuffers, BackGroundForeGround
    ' See CmdAcquire_Click( ) for how to start this task and process data
    
    If Autozero.Value = 1 Then
        mydevice.SR.Sel_chan_0_ref = DL_HARDWARE_ZEROREF
    Else
        mydevice.SR.Sel_chan_0_ref = DL_DISABLE_ZEROREF
    End If
        
    NumberOfSamples = Text2.Text
    
    FullSweep = NumberOfSamples * SamplingPeriod

    mydevice.samples = NumberOfSamples

    If (NumberOfChannels > 0) Then
    ReDim DataArray(0 To NumberOfChannels - 1, 0 To NumberOfSamples - 1) As Double
    ReDim countsarray(0 To NumberOfChannels - 1, 0 To NumberOfSamples - 1) As Long
    End If
    
    Call Setup_Device
        
    ' 4. Setup the Service Request control for Multi-Channel, analog input
    '    utilizing a channel gain list.
    SetupDriverLINXMultiChannelGainList mydevice.SR, mydevice.LDD, mydevice.device, _
                                        DL_AI, LogicalChannels(), ChannelGains(), _
                                        mydevice.freq, mydevice.samples, _
                                        NumberOfChannels, NumberOfBuffers, _
                                        mydevice.DMAorINT, channelSEDE()
    
    
    If Check2.Value = 1 Then
        'Digital trigger
        Call AddStartEventDigitalTrigger(mydevice.SR, Check3.Value)
    End If
    
    If Check4.Value = 1 Then
        Call AddTimingEventExternalDigitalClock(mydevice.SR)
    End If
    
    If Check5.Value = 1 Then
        'Analog trigger checked
        'check6 is the analog trigger polarity
        MsgBox "Analog trigger is not yet supported in this application...Refer to AISTPTRG example"
        
    End If
    
    ' 5. Execute the Service Request specified when this
    '    form loaded. (See Form_Load( ) for details.)
    DriverLINXSR1.Refresh
    ' NOTE: Bufered I/O tasks execute asynchronously, i.e., the data
    '       is not available when the call to the Refresh method
    '       returns. To process results from buffered I/O tasks, handle
    '       events from the DriverLINXSR control. In this example, see
    '       the following subroutines:
    '           DriverLINXSR1_ServiceStart,
    '           DriverLINXSR1_BufferFilled, and
    '           DriverLINXSR1_ServiceDone.
    
    ' Display status or error information in this form's status box
    DLResultCode = GetDriverLINXStatus(DriverLINXSR1, DLMessage)
    If DLResultCode <> DL_NoErr Then
        strStatus = DLMessage
    End If
    
    lblStatus.Caption = strStatus
    
End Sub

Private Sub DriverLINXSR1_ServiceStart(task As Integer, device As Integer, subsystem As Integer, mode As Integer)

    ' The DriverLINXSR calls this subroutine when a task starts. This
    '   application uses this ServiceStart event to update the form,
    '   indicating that a task is currently running.
    strStatus = msgRunning
    lblStatus.Caption = strStatus
    
    ' Disable the start button while a task is running
    cmdAcquire.Enabled = False
    
End Sub

Private Sub DriverLINXSR1_BufferFilled(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Integer)
    
    Dim samples As Long
    Dim an_answer As myanswer

    ' 6. Process results:
    '    Because buffered I/O tasks execute asynchronously, your
    '    application will not have any data to process until your
    '    DriverLINXSR control informs it that a buffer has filled.
    '    When you set the DriverLINXSR property, Sel_buf_notify, equal
    '    to DL_NOTIFY, the DriverLINXSR control calls this subroutine
    '    whenever it has filled a buffer with new data. At this point,
    '    you can transfer the data in this buffer from the DriverLINXSR
    '    control to an array defined in your application.
    samples = MyGetDriverLINXAIBuffer(DriverLINXSR1, bufIndex, DataArray(), countsarray())
    
    List2.Clear
    For i = 0 To NumberOfChannels - 1
    
        If Option3.Value = True Then
            'volts
            an_answer = GET_MY_STATS(i, DataArray(), mydevice)
        Else
            'counts
            an_answer = GET_MY_STATS_C(i, countsarray(), mydevice)
        End If
        
        List2.AddItem Str(Round(an_answer.volts, 9)) + ", " + Str(Round(an_answer.stdvolts, 9)) + ", " + Str(Round(an_answer.ppvolts, 9))
    
    Next i
        
    Label13.Caption = NumberOfSamples
    
    ' Display the new data
    ShowAnalogResults pictureCRT, NumberOfChannels, NumberOfSamples, SamplingFrequency, DataArray()

End Sub

Private Sub DriverLINXSR1_ServiceDone(task As Integer, device As Integer, subsystem As Integer, mode As Integer)

    ' The DriverLINXSR calls this subroutine when a task ends. This
    '   application uses this ServiceDone event to update the form,
    '   indicating that no task is running.
    strStatus = msgStopped
    lblStatus.Caption = strStatus
    
    ' Reenable the start button when a task ends.
    cmdAcquire.Enabled = True
    
    If Check1.Value = 1 Then
        
        DoEvents
        
        cmdAcquire_Click

    End If
        
End Sub

Private Sub cmdExit_Click()

    Dim DLStatusCode As Integer
    
    ' Make sure that there are no active tasks
    DLStatusCode = StopDriverLINXIO(DriverLINXSR1)
    
    ' If active task is found, do not exit until DriverLINX notifies
    '   you that it is really done.
    If DLStatusCode = DL_NoErr Then
        Do
            DoEvents
        Loop Until cmdAcquire.Enabled
    End If
            
    ' 7. Close the DriverLINX Driver
    CloseDriverLINXDriver DriverLINXSR1
    
    ' Quit this application
    Unload Me
    End
    
End Sub

Private Sub Form_Terminate()
End     'Terminate the application
End Sub





Private Sub Option1_Click()
Option1.Value = True
Option2.Value = False

BackGroundForeGround = 2

mydevice.DMAorINT = 2

Call Setup_Device

End Sub

Private Sub Option2_Click()
Option2.Value = True
Option1.Value = False

BackGroundForeGround = 1

mydevice.DMAorINT = 1

Call Setup_Device

End Sub

Private Sub Option3_Click()
Option3.Value = True
Option4.Value = False

End Sub

Private Sub Option4_Click()
Option4.Value = True
Option3.Value = False
End Sub

Private Sub Text1_LostFocus()
    
    SamplingFrequency = Text1.Text
    SamplingPeriod = 1 / SamplingFrequency
    
    FullSweep = NumberOfSamples * SamplingPeriod

    mydevice.freq = SamplingFrequency
    
    Call Setup_Device

End Sub

Private Sub Text3_LostFocus()
    
    Call Setup_Device

    Label5.Caption = -Val(Text3.Text)
    
End Sub

Private Sub Text6_LostFocus()
    mydevice.device = Text6.Text
    Call Initialize_Device(mydevice)
    
End Sub

